using System;
using Server;
using Server.Targeting;
using Server.Mobiles;
using System.Collections;

namespace Server.Items
{
    public class NightshadePlant : Item
    {

        [Constructable]
        public NightshadePlant() : base(6373)
        {
            Weight = 1.0;
            Stackable = false;
            Name = "nightshade plant";
        }

        public NightshadePlant(Serial serial) : base(serial)
        {
        }
        
        public override void OnDoubleClick(Mobile from)
        {

            if (!IsChildOf(from.Backpack))
            {
                from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
            }
            else if (from.InRange(this.GetWorldLocation(), 1))
            {
                this.SendLocalizedMessageTo(from, 1010086);
                from.Target = new NightshadePlantTarget(this);
            }
            else
            {
                from.SendLocalizedMessage(500446); // That is too far away. 
            }
        }
        
    		public override void GetProperties( ObjectPropertyList list )
    		{
    			base.GetProperties( list );
    
            list.Add("+1 to base damage");
    		}

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }


        private class NightshadePlantTarget : Target
        {
            private Mobile m_Owner;

            private NightshadePlant m_Plant;

            public NightshadePlantTarget( NightshadePlant plant ) : base(10, false, TargetFlags.None)
            {
                m_Plant = plant;
            }

            protected override void OnTarget( Mobile from, object target )
            {
                if (target is BaseCreature)
                {
                    BaseCreature c = (BaseCreature)target;
                    if (c.Controlled == false)
                        from.SendMessage("Zvire musi byt ochocene.");
                    else if ( c.ControlMaster != from )
                        from.SendMessage("Toto neni tve zvire.");
                    else if ( c.IsDeadPet )
                        from.SendMessage("Nemuzes krmit mrtve zvire.");
                    else if ( c.ControlMaster != from )
                        from.SendMessage("Toto neni tve zvire.");
                    else if ( c is BaseHire )
                        from.SendMessage("Nemuzes krmit najmute pomocniky");
                    else if ( c.Summoned || c is BaseTalismanSummon )
                        from.SendMessage("Nemuzes krmit vyvolane pomocniky.");
                    else if ( c is Xanthos.Interfaces.IEvoCreature && !GinsengPlant.IsAllowedEvoPet( (Xanthos.Interfaces.IEvoCreature) c ) )
                        from.SendMessage("Toto nemuze snist evolution pet.");
                    else if ( c.Controlled == true && c.ControlMaster == from )
                    {
                        if ( c.DamageMax > 29 )
                           from.SendMessage("Toto zvire jiz dosahlo maximalni damage.");
                        else
                        {
                           c.DamageMax += 1;
                           c.DamageMin += 1;
                           
          						if ( c.Body.IsAnimal )
          							c.Animate( 3, 5, 1, true, false, 0 );
          						else if ( c.Body.IsMonster )
          							c.Animate( 17, 5, 1, true, false, 0 );
                           
                           c.PlaySound( Utility.Random( 0x3A, 3 ) );
                           c.FixedParticles( 0x376A, 9, 32, 5008, EffectLayer.Waist );
                           m_Plant.Delete();
                           c.PlaySound( 0x1EB );
                        }
                    }
                     else
                     {
                        from.SendMessage("You cant do that.");
                     }
                }
                else
                {
                    from.SendMessage("Toto muzes snist jen tvoje ochocene zvire.");
                }
            }
        }
    }
}
